@extends('layout')
@section('title')
    <i class="icon icon-dashboard"></i> Welcome <strong>{{ $page->companyName }}</strong>
@endsection
@section('content')
    <div class="col-xs-12">
        <div class="hr-page-header">
            <div class="hr-page-title">
                Latest Announcements
            </div>
        </div>
        @if($page->announcement != null)
            <div class="announcement bg-dark">
                <div class="announcement-icon">
                    <i class="icon icon-announcements"></i>
                </div>
                <div class="details">
                    {{ $page->announcement->details }}
                </div>
                @if($page->announcement->attachment != '')
                    <div class="attachment">
                        <a href="{{ URL::asset($page->announcement->attachment) }}"
                           class="btn btn-green">
                            Download
                        </a>
                    </div>
                @endif
                <div class="time">
                    On: {{ \Carbon\Carbon::parse($page->announcement->date_from)->toDateString() }}
                </div>
            </div>
        @else
            <div class="media ">
                <div class="media-body">
                    No new announcements...
                </div>
            </div>
        @endif
    </div>
    <div class="col-xs-12">
        <div class="center-block">
            <div class="hr-page-header">
                <div class="hr-page-title">
                    Requests Stats
                </div>
            </div>
            <form method="post" action="{{URL::action('UserController@postDashboard')}}">
                {{csrf_field()}}
                <div class="form-inline text-center">
                    <label for="datepicker" class="control-label">Period</label>
                    <div class="input-daterange input-group" id="datepicker">
                        <input type="text" class="input-sm form-control" name="start" value="{{$page->requestsStats->dateFrom}}"/>
                        <span class="input-group-addon">to</span>
                        <input type="text" class="input-sm form-control" name="end" value="{{$page->requestsStats->dateTo}}"/>
                    </div>
                    <button type="submit" class="btn btn-dark">Go</button>
                </div>
            </form>
        </div>
        <hr>
        <div class="center-block text-center">
            <canvas width="640" height="480" id="requestsStats"></canvas>
        </div>
    </div>
@endsection
@section('pageScripts')
    <script src="{{ URL::asset('assets/js/vendor/chart.js')}}" type="text/javascript"></script>
    <script>
        $('.input-daterange').datepicker({
            format: "yyyy-mm-dd",
            startView: 1,
            minViewMode: 1,
            maxViewMode: 1
        });
        var ctx = $('#requestsStats').get(0).getContext("2d")
        var data = {
            labels: {!! $page->requestsStats->labels !!},
            datasets: [
                {
                    label: "Approved",
                    fillColor: "#44c535",
                    strokeColor: "#384950",
                    highlightFill: "#44a535",
                    highlightStroke: "#384950",
                    data: {!! $page->requestsStats->approved !!}
                },
                {
                    label: "Rejected",
                    fillColor: "#d60000",
                    strokeColor: "#384950",
                    highlightFill: "#c60000",
                    highlightStroke: "#384950",
                    data: {!!$page->requestsStats->rejected !!}
                },
                {
                    label: "Pending",
                    fillColor: "darkorange",
                    strokeColor: "#384950",
                    highlightFill: "orange",
                    highlightStroke: "#384950",
                    data: {!!$page->requestsStats->pending !!}
                }
            ]
        }
        var requestsChart = new Chart(ctx).Bar(data)
    </script>
@endsection